/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.pinin.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Stream;
import me.towdium.pinin.PinIn;
import me.towdium.pinin.elements.Element;
import me.towdium.pinin.elements.Phoneme;
import me.towdium.pinin.utils.IndexSet;

public class Pinyin
implements Element {
    boolean duo = false;
    boolean sequence = false;
    public final int id;
    String raw;
    private Phoneme[] phonemes;

    public Pinyin(String str, PinIn p, int id) {
        this.raw = str;
        this.id = id;
        this.reload(str, p);
    }

    public Phoneme[] phonemes() {
        return this.phonemes;
    }

    @Override
    public IndexSet match(String str, int start, boolean partial) {
        IndexSet ret;
        if (this.duo) {
            ret = IndexSet.ZERO;
            ret = this.phonemes[0].match(str, ret, start, partial);
            ret = this.phonemes[1].match(str, ret, start, partial);
            ret.merge(this.phonemes[2].match(str, ret, start, partial));
        } else {
            Phoneme phoneme;
            IndexSet active = IndexSet.ZERO;
            ret = new IndexSet();
            Phoneme[] phonemeArray = this.phonemes;
            int n = phonemeArray.length;
            for (int i = 0; i < n && !(active = (phoneme = phonemeArray[i]).match(str, active, start, partial)).isEmpty(); ++i) {
                ret.merge(active);
            }
        }
        if (this.sequence && this.phonemes[0].matchSequence(str.charAt(start))) {
            ret.set(1);
        }
        return ret;
    }

    public String toString() {
        return this.raw;
    }

    public void reload(String str, PinIn p) {
        Collection<String> split = p.keyboard().split(str);
        ArrayList<Phoneme> l = new ArrayList<Phoneme>();
        for (String s : split) {
            l.add(p.getPhoneme(s));
        }
        this.phonemes = l.toArray(new Phoneme[0]);
        this.duo = p.keyboard().duo;
        this.sequence = p.keyboard().sequence;
    }

    public static boolean hasInitial(String s) {
        return Stream.of(Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u'), Character.valueOf('v')).noneMatch(i -> s.charAt(0) == i.charValue());
    }
}

